/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class UrzasSylexEffect
extends OneShotEffect {
    UrzasSylexEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player chooses six lands they control. Destroy all other permanents";
    }

    private UrzasSylexEffect(UrzasSylexEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrzasSylexEffect copy() {
        return new UrzasSylexEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet toKeep = new HashSet();
        Map<UUID, Set> landMap = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game).stream().collect(Collectors.groupingBy(Controllable::getControllerId, Collectors.toCollection(() -> new HashSet())));
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            Set lands = landMap.getOrDefault(playerId, Collections.emptySet());
            if (lands.size() <= 6) {
                lands.stream().map(MageItem::getId).forEach(toKeep::add);
                continue;
            }
            TargetPermanent target = new TargetPermanent(6, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            toKeep.addAll(target.getTargets());
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(StaticFilters.FILTER_PERMANENT, source.getControllerId(), source, game)) {
            if (toKeep.contains(permanent.getId())) continue;
            permanent.destroy(source, game);
        }
        return true;
    }
}

