/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PowerIslandPredicate
implements ObjectSourcePlayerPredicate<Permanent> {
    static final FilterLandPermanent filter = new FilterLandPermanent("Island");

    PowerIslandPredicate() {
    }

    public boolean apply(ObjectSourcePlayer<Permanent> input, Game game) {
        Permanent permanent = (Permanent)input.getObject();
        if (permanent != null) {
            int islands = game.getBattlefield().countAll((FilterPermanent)filter, input.getPlayerId(), game);
            if (permanent.getPower().getValue() <= islands) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "creature with power less than or equal to the number of Islands you control";
    }

    static {
        filter.add((Predicate)SubType.ISLAND.getPredicate());
    }
}

