/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TurnOverEffect
extends OneShotEffect {
    TurnOverEffect() {
        super(Outcome.Benefit);
        this.staticText = "Turn over target nontoken creature";
    }

    private TurnOverEffect(TurnOverEffect effect) {
        super((OneShotEffect)effect);
    }

    public TurnOverEffect copy() {
        return new TurnOverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature != null) {
            if (creature.isFaceDown(game)) {
                creature.turnFaceUp(source, game, source.getControllerId());
            } else {
                creature.turnFaceDown(source, game, source.getControllerId());
                MageObjectReference objectReference = new MageObjectReference(creature.getId(), creature.getZoneChangeCounter(game), game);
                game.addEffect((ContinuousEffect)new BecomesFaceDownCreatureEffect(null, objectReference, Duration.Custom, BecomesFaceDownCreatureEffect.FaceDownType.MANUAL), source);
            }
            return true;
        }
        return false;
    }
}

