/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.util.CardUtil;

class VaanStreetThiefEffect
extends OneShotEffect {
    VaanStreetThiefEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of that player's library. You may cast it. If you don't, create a Treasure token";
    }

    private VaanStreetThiefEffect(VaanStreetThiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public VaanStreetThiefEffect copy() {
        return new VaanStreetThiefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        if (!controller.chooseUse(Outcome.DrawCard, "Cast " + card.getIdName() + '?', source, game) || !CardUtil.castSingle((Player)controller, (Ability)source, (Game)game, (Card)card)) {
            new TreasureToken().putOntoBattlefield(1, game, source);
        }
        return true;
    }
}

