/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.common.SourcePermanentPowerValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class VadrikAstralArchmageEffect
extends CostModificationEffectImpl {
    VadrikAstralArchmageEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "instant and sorcery spells you cast cost {X} less to cast, where X is {this}'s power";
    }

    private VadrikAstralArchmageEffect(VadrikAstralArchmageEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)SourcePermanentPowerValue.NOT_NEGATIVE.calculate(game, source, (Effect)this));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId()) && ((SpellAbility)abilityToModify).getCharacteristics(game).isInstantOrSorcery(game) && game.getCard(abilityToModify.getSourceId()) != null;
    }

    public VadrikAstralArchmageEffect copy() {
        return new VadrikAstralArchmageEffect(this);
    }
}

