/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ValakutExplorationDamageEffect
extends OneShotEffect {
    ValakutExplorationDamageEffect() {
        super(Outcome.Benefit);
        this.staticText = "put them into their owner's graveyard, then {this} deals that much damage to each opponent";
    }

    private ValakutExplorationDamageEffect(ValakutExplorationDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public ValakutExplorationDamageEffect copy() {
        return new ValakutExplorationDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC()));
        if (exileZone == null) {
            return false;
        }
        int count = exileZone.size();
        if (count < 1) {
            return false;
        }
        player.moveCards((Cards)exileZone, Zone.GRAVEYARD, source, game);
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            player = game.getPlayer(playerId);
            if (playerId == null) continue;
            player.damage(count, source.getSourceId(), source, game);
        }
        return true;
    }
}

