/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Library;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ValakutExplorationExileEffect
extends OneShotEffect {
    ValakutExplorationExileEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile the top card of your library. You may play that card for as long as it remains exiled";
    }

    private ValakutExplorationExileEffect(ValakutExplorationExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public ValakutExplorationExileEffect copy() {
        return new ValakutExplorationExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourcePermanent == null || controller == null || !controller.getLibrary().hasCards()) {
            return false;
        }
        Library library = controller.getLibrary();
        Card card = library.getFromTop(game);
        if (card == null) {
            return true;
        }
        controller.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC()), sourcePermanent.getIdName());
        PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Duration.EndOfGame);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

