/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ValgavothTerrorEaterPlayEffect
extends AsThoughEffectImpl {
    ValgavothTerrorEaterPlayEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.AIDontUseIt);
        this.staticText = "during your turn, you may play cards exiled with {this}. If you cast a spell this way, pay life equal to its mana value rather than pay its mana cost";
    }

    private ValgavothTerrorEaterPlayEffect(ValgavothTerrorEaterPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public ValgavothTerrorEaterPlayEffect copy() {
        return new ValgavothTerrorEaterPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId) || !game.isActivePlayer(affectedControllerId)) {
            return false;
        }
        Player player = game.getPlayer(affectedControllerId);
        if (player == null) {
            return false;
        }
        Card card = game.getCard(objectId);
        if (card == null) {
            return false;
        }
        UUID mainId = card.getMainCard().getId();
        MageObject sourceObject = source.getSourceObject(game);
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)sourceObject.getId(), (int)sourceObject.getZoneChangeCounter(game));
        ExileZone exileZone = game.getExile().getExileZone(exileZoneId);
        if (exileZone == null || !exileZone.contains((Object)mainId)) {
            return false;
        }
        if (!card.isLand(game)) {
            PayLifeCost lifeCost = new PayLifeCost(card.getSpellAbility().getManaCosts().manaValue());
            CostsImpl newCosts = new CostsImpl();
            newCosts.add((Object)lifeCost);
            newCosts.addAll((Collection)card.getSpellAbility().getCosts());
            player.setCastSourceIdWithAlternateMana(card.getId(), null, (Costs)newCosts, MageIdentifier.ValgavothTerrorEaterAlternateCast);
        }
        return true;
    }
}

