/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class ValiantChangelingCostReductionEffect
extends CostModificationEffectImpl {
    ValiantChangelingCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "This spell costs {1} less to cast for each creature type among creatures you control. This effect can't reduce the amount of mana this spell costs by more than {5}.";
    }

    private ValiantChangelingCostReductionEffect(ValiantChangelingCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        HashSet<SubType> subTypes = new HashSet<SubType>();
        int reductionAmount = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            if (permanent.isAllCreatureTypes(game)) {
                reductionAmount = 5;
                break;
            }
            subTypes.addAll((Collection<SubType>)permanent.getSubtype(game));
            subTypes.removeIf(subType -> subType.getSubTypeSet() != SubTypeSet.CreatureType);
            reductionAmount = subTypes.size();
            if (reductionAmount <= 4) continue;
            break;
        }
        CardUtil.reduceCost((Ability)abilityToModify, (int)Math.min(reductionAmount, 5));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId())) {
            return game.getCard(abilityToModify.getSourceId()) != null;
        }
        return false;
    }

    public ValiantChangelingCostReductionEffect copy() {
        return new ValiantChangelingCostReductionEffect(this);
    }
}

