/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.token.KnightToken;
import mage.players.Player;

class ValiantEndeavorEffect
extends OneShotEffect {
    ValiantEndeavorEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Roll two d6 and choose one result. Destroy each creature with power greater than or equal to that result. Then create a number of 2/2 white Knight creature tokens with vigilance equal to the other result.";
    }

    private ValiantEndeavorEffect(ValiantEndeavorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ValiantEndeavorEffect copy() {
        return new ValiantEndeavorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int second;
        int first;
        int secondResult;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        List results = controller.rollDice(this.outcome, source, game, 6, 2, 0);
        int firstResult = (Integer)results.get(0);
        if (firstResult != (secondResult = ((Integer)results.get(1)).intValue()) && controller.chooseUse(this.outcome, "Destroy each creature with power greater than or equal to your choice", "The other number will be the amount of 2/2 white Knight tokens with vigilance.", "" + firstResult, "" + secondResult, source, game)) {
            first = firstResult;
            second = secondResult;
        } else {
            first = secondResult;
            second = firstResult;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent(String.format("creatures with power greater than or equal to %s", first));
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, first - 1));
        DestroyAllEffect wrathEffect = new DestroyAllEffect((FilterPermanent)filter);
        wrathEffect.apply(game, source);
        new KnightToken().putOntoBattlefield(second, game, source, source.getControllerId());
        return true;
    }
}

