/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.keyword.CyclingAbility;
import mage.cards.v.ValiantRescuerWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.HumanSoldierToken;
import mage.game.permanent.token.Token;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;

class ValiantRescuerTriggeredAbility
extends TriggeredAbilityImpl {
    ValiantRescuerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new HumanSoldierToken()));
        this.addWatcher(new ValiantRescuerWatcher());
    }

    private ValiantRescuerTriggeredAbility(ValiantRescuerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ValiantRescuerWatcher watcher = (ValiantRescuerWatcher)game.getState().getWatcher(ValiantRescuerWatcher.class);
        if (watcher == null || !watcher.checkSpell(event.getPlayerId(), event.getSourceId()) || !event.getPlayerId().equals(this.getControllerId()) || event.getSourceId().equals(this.getSourceId())) {
            return false;
        }
        StackObject item = game.getState().getStack().getFirstOrNull();
        return item instanceof StackAbility && item.getStackAbility() instanceof CyclingAbility;
    }

    public ValiantRescuerTriggeredAbility copy() {
        return new ValiantRescuerTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you cycle another card for the first time each turn, create a 1/1 white Human Soldier creature token.";
    }
}

