/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class VancesBlastingCannonsExileEffect
extends OneShotEffect {
    VancesBlastingCannonsExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. If it's a nonland card, you may cast that card this turn";
    }

    private VancesBlastingCannonsExileEffect(VancesBlastingCannonsExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public VancesBlastingCannonsExileEffect copy() {
        return new VancesBlastingCannonsExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (!card.isLand(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)false);
        }
        return true;
    }
}

