/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class VanilleCheerfulLCieEffect
extends OneShotEffect {
    VanilleCheerfulLCieEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then return a permanent card from your graveyard to your hand";
    }

    private VanilleCheerfulLCieEffect(VanilleCheerfulLCieEffect effect) {
        super((OneShotEffect)effect);
    }

    public VanilleCheerfulLCieEffect copy() {
        return new VanilleCheerfulLCieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_PERMANENT, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_PERMANENT);
        target.withNotTarget(true);
        player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.HAND, source, game);
    }
}

