/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.discard.DiscardControllerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class VarinaLichQueenTriggeredAbility
extends TriggeredAbilityImpl {
    public VarinaLichQueenTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private VarinaLichQueenTriggeredAbility(VarinaLichQueenTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VarinaLichQueenTriggeredAbility copy() {
        return new VarinaLichQueenTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int attackingZombies = 0;
        for (UUID attacker : game.getCombat().getAttackers()) {
            Permanent creature = game.getPermanent(attacker);
            if (creature == null || creature.getControllerId() == null || !creature.isControlledBy(this.getControllerId()) || !creature.hasSubtype(SubType.ZOMBIE, game)) continue;
            ++attackingZombies;
        }
        if (attackingZombies > 0) {
            this.getEffects().clear();
            this.addEffect((Effect)new DrawCardSourceControllerEffect(attackingZombies));
            this.addEffect((Effect)new DiscardControllerEffect(attackingZombies, false));
            this.addEffect((Effect)new GainLifeEffect(attackingZombies));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever you attack with one or more Zombies, draw that many cards, then discard that many cards. You gain that much life.";
    }
}

