/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class VarragothBloodskySireEffect
extends SearchEffect {
    VarragothBloodskySireEffect() {
        super(new TargetCardInLibrary(), Outcome.DrawCard);
        this.staticText = "Target player searches their library for a card, then shuffles and puts that card on top";
    }

    private VarragothBloodskySireEffect(VarragothBloodskySireEffect effect) {
        super((SearchEffect)effect);
    }

    public VarragothBloodskySireEffect copy() {
        return new VarragothBloodskySireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            if (player.searchLibrary(this.target, source, game)) {
                CardsImpl foundCards = new CardsImpl((Collection)this.target.getTargets());
                player.shuffleLibrary(source, game);
                player.putCardsOnTopOfLibrary((Cards)foundCards, game, source, false);
                return true;
            }
            player.shuffleLibrary(source, game);
        }
        return false;
    }
}

