/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCreaturePermanentAmount;

class VastwoodHydraDistributeEffect
extends OneShotEffect {
    VastwoodHydraDistributeEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "distribute a number of +1/+1 counters equal to the number of +1/+1 counters on {this} among any number of creatures you control";
    }

    private VastwoodHydraDistributeEffect(VastwoodHydraDistributeEffect effect) {
        super((OneShotEffect)effect);
    }

    public VastwoodHydraDistributeEffect copy() {
        return new VastwoodHydraDistributeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = new CountersSourceCount(CounterType.P1P1).calculate(game, source, (Effect)this);
        if (amount <= 0) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game) < 1) {
            return false;
        }
        TargetCreaturePermanentAmount target = new TargetCreaturePermanentAmount(amount, 0, amount, StaticFilters.FILTER_CONTROLLED_CREATURE);
        target.withNotTarget(true);
        target.withChooseHint("to distribute " + amount + " counters");
        target.chooseTarget(this.outcome, player.getId(), source, game);
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(target.getTargetAmount(targetId)), source, game);
        }
        return true;
    }
}

