/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.util.CardUtil;

class Vault101BirthdayPartyEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("an Aura or Equipment card from your hand or graveyard");

    Vault101BirthdayPartyEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "you may put an Aura or Equipment card from your hand or graveyard onto the battlefield. If an Equipment is put onto the battlefield this way, you may attach it to a creature you control.";
    }

    private Vault101BirthdayPartyEffect(Vault101BirthdayPartyEffect effect) {
        super((OneShotEffect)effect);
    }

    public Vault101BirthdayPartyEffect copy() {
        return new Vault101BirthdayPartyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)player.getHand().getCards(filter, source.getControllerId(), source, game));
        cards.addAllCards((Collection)player.getGraveyard().getCards(filter, source.getControllerId(), source, game));
        if (cards.isEmpty()) {
            return false;
        }
        TargetCard targetCard = new TargetCard(0, 1, Zone.ALL, filter);
        targetCard.withNotTarget(true);
        player.choose(this.outcome, (Cards)cards, targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent equipment = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (equipment == null || !equipment.hasSubtype(SubType.EQUIPMENT, game)) {
            return true;
        }
        TargetControlledCreaturePermanent targetPermanent = new TargetControlledCreaturePermanent(0, 1);
        targetCard.withNotTarget(true);
        player.choose(this.outcome, (Target)targetPermanent, source, game);
        Permanent permanent = game.getPermanent(targetPermanent.getFirstTarget());
        if (permanent != null) {
            permanent.addAttachment(equipment.getId(), source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.AURA.getPredicate(), (Predicate)SubType.EQUIPMENT.getPredicate()));
    }
}

