/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PutOnLibraryTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class Vault13DwellersJourneyEffect
extends OneShotEffect {
    Vault13DwellersJourneyEffect() {
        super(Outcome.Benefit);
        this.staticText = "return two cards exiled with {this} to the battlefield under their owners' control and put the rest on the bottom of their owners' libraries";
    }

    private Vault13DwellersJourneyEffect(Vault13DwellersJourneyEffect effect) {
        super((OneShotEffect)effect);
    }

    public Vault13DwellersJourneyEffect copy() {
        return new Vault13DwellersJourneyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl();
        Optional.ofNullable(game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source))).ifPresent(arg_0 -> ((Cards)cards).addAll(arg_0));
        if (player == null || cards.isEmpty()) {
            return false;
        }
        CardsImpl toPlay = new CardsImpl();
        if (cards.size() > 2) {
            TargetCardInExile target = new TargetCardInExile(2, 2, StaticFilters.FILTER_CARD_CARDS);
            target.withNotTarget(true);
            target.withChooseHint("to return to the battlefield");
            player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
            toPlay.addAll((Collection)target.getTargets());
        } else {
            toPlay.addAll((Collection)cards);
        }
        toPlay.retainZone(Zone.EXILED, game);
        if (!toPlay.isEmpty()) {
            player.moveCards(toPlay.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
            cards.retainZone(Zone.EXILED, game);
        }
        if (!cards.isEmpty()) {
            PutOnLibraryTargetEffect e = new PutOnLibraryTargetEffect(false);
            e.setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game));
            e.apply(game, source);
        }
        return true;
    }
}

