/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class VedalkenEngineerEffect
extends ManaEffect {
    private final int amount;
    private final ConditionalManaBuilder manaBuilder;

    public VedalkenEngineerEffect(int amount, ConditionalManaBuilder manaBuilder) {
        this.amount = amount;
        this.manaBuilder = manaBuilder;
        this.staticText = "Add " + CardUtil.numberToText((int)amount) + " mana of any one color. " + manaBuilder.getRule();
    }

    private VedalkenEngineerEffect(VedalkenEngineerEffect effect) {
        super((ManaEffect)effect);
        this.amount = effect.amount;
        this.manaBuilder = effect.manaBuilder;
    }

    public VedalkenEngineerEffect copy() {
        return new VedalkenEngineerEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        Mana.AnyMana((int)this.amount);
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        if (game != null) {
            Player controller = game.getPlayer(source.getControllerId());
            ChoiceColor choiceColor = new ChoiceColor(true);
            if (controller != null && controller.choose(Outcome.Benefit, (Choice)choiceColor, game)) {
                return (Mana)this.manaBuilder.setMana(choiceColor.getMana(this.amount), source, game).build(new Object[0]);
            }
        }
        return new Mana();
    }
}

