/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class VeilstoneAmuletEffect
extends ContinuousRuleModifyingEffectImpl {
    VeilstoneAmuletEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "creatures you control can't be the targets of spells or abilities your opponents control this turn";
    }

    private VeilstoneAmuletEffect(VeilstoneAmuletEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public VeilstoneAmuletEffect copy() {
        return new VeilstoneAmuletEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    public boolean applies(GameEvent event, Ability ability, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(ability.getControllerId()) && game.getPlayer(ability.getControllerId()).hasOpponent(event.getPlayerId(), game);
    }
}

