/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.DiscardCardYouChooseTargetEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class VenarianGlimmerEffect
extends OneShotEffect {
    VenarianGlimmerEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player reveals their hand. You choose a nonland card with mana value X or less from it. That player discards that card";
    }

    private VenarianGlimmerEffect(VenarianGlimmerEffect effect) {
        super((OneShotEffect)effect);
    }

    public VenarianGlimmerEffect copy() {
        return new VenarianGlimmerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            FilterNonlandCard filter = new FilterNonlandCard();
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0) + 1));
            DiscardCardYouChooseTargetEffect effect = new DiscardCardYouChooseTargetEffect((FilterCard)filter);
            effect.setTargetPointer(this.getTargetPointer().copy());
            effect.apply(game, source);
            return true;
        }
        return false;
    }
}

