/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class VengefulRebirthEffect
extends OneShotEffect {
    VengefulRebirthEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Return target card from your graveyard to your hand. If you return a nonland card to your hand this way, {this} deals damage equal to that card's mana value to any target";
    }

    private VengefulRebirthEffect(VengefulRebirthEffect effect) {
        super((OneShotEffect)effect);
    }

    public VengefulRebirthEffect copy() {
        return new VengefulRebirthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (controller == null || card == null) {
            return false;
        }
        if (!controller.moveCards(card, Zone.HAND, source, game)) {
            return false;
        }
        if (card.isLand(game)) {
            return true;
        }
        int damage = card.getManaValue();
        Permanent permanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (permanent != null) {
            permanent.damage(damage, source.getSourceId(), source, game, false, true);
            return true;
        }
        Player targetPlayer = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget());
        if (targetPlayer != null) {
            targetPlayer.damage(damage, source.getSourceId(), source, game);
        }
        return true;
    }
}

