/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.PlantWarriorToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class VengefulRegrowthEffect
extends OneShotEffect {
    VengefulRegrowthEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "Return up to three target land cards from your graveyard to the battlefield tapped. Create that many 4/2 green Plant Warrior creature tokens with reach.";
    }

    private VengefulRegrowthEffect(VengefulRegrowthEffect effect) {
        super((OneShotEffect)effect);
    }

    public VengefulRegrowthEffect copy() {
        return new VengefulRegrowthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()));
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        cards.retainZone(Zone.BATTLEFIELD, game);
        int returned = cards.size();
        if (returned > 0) {
            new CreateTokenEffect((Token)new PlantWarriorToken(), returned).apply(game, source);
        }
        return true;
    }
}

