/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class VenomTriggeredAbility
extends TriggeredAbilityImpl {
    VenomTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
    }

    private VenomTriggeredAbility(VenomTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VenomTriggeredAbility copy() {
        return new VenomTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantedCreature;
        Permanent blocker = game.getPermanent(event.getSourceId());
        Permanent blocked = game.getPermanent(event.getTargetId());
        Permanent enchantment = game.getPermanent(this.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && (enchantedCreature = game.getPermanent(enchantment.getAttachedTo())) != null) {
            if (blocker != null && !Objects.equals(blocker, enchantedCreature) && !blocker.hasSubtype(SubType.WALL, game) && Objects.equals(blocked, enchantedCreature)) {
                ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(blocker.getId(), game));
                return true;
            }
            if (blocker != null && Objects.equals(blocker, enchantedCreature) && !blocked.hasSubtype(SubType.WALL, game)) {
                ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(blocked.getId(), game));
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever enchanted creature blocks or becomes blocked by a non-Wall creature, destroy that creature at end of combat.";
    }
}

