/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class VerdantSuccessionEffect
extends OneShotEffect {
    private final String creatureName;
    private final UUID controllerId;

    VerdantSuccessionEffect(String creatureName, UUID controllerId) {
        super(Outcome.PutCardInPlay);
        this.creatureName = creatureName;
        this.controllerId = controllerId;
    }

    private VerdantSuccessionEffect(VerdantSuccessionEffect effect) {
        super((OneShotEffect)effect);
        this.creatureName = effect.creatureName;
        this.controllerId = effect.controllerId;
    }

    public VerdantSuccessionEffect copy() {
        return new VerdantSuccessionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(this.controllerId);
        if (controller == null) {
            return false;
        }
        MageObject mageObject = game.getObject(source);
        if (mageObject == null) {
            return false;
        }
        FilterCard filterCard = new FilterCard("Card named " + this.creatureName);
        filterCard.add((Predicate)new NamePredicate(this.creatureName));
        TargetCardInLibrary target = new TargetCardInLibrary(filterCard);
        controller.searchLibrary(target, source, game);
        if (target.getTargets().isEmpty()) {
            return false;
        }
        Card card = game.getCard(target.getFirstTarget());
        if (card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            controller.shuffleLibrary(source, game);
        }
        return true;
    }
}

