/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Comparator;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.PlayFromTopOfLibraryEffect;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandCard;
import mage.game.Game;

class VergeRangersEffect
extends PlayFromTopOfLibraryEffect {
    private static final FilterCard filter = new FilterLandCard("play lands");

    VergeRangersEffect() {
        super(filter);
        this.staticText = "As long as an opponent controls more lands than you, you may play lands from the top of your library";
    }

    private VergeRangersEffect(VergeRangersEffect effect) {
        super((PlayFromTopOfLibraryEffect)effect);
    }

    public VergeRangersEffect copy() {
        return new VergeRangersEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!super.applies(objectId, source, affectedControllerId, game)) {
            return false;
        }
        int myLandCount = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), game);
        int maxOpponentLandCount = game.getOpponents(source.getControllerId()).stream().map(opponentId -> game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, opponentId, game)).max(Comparator.naturalOrder()).orElse(0);
        return maxOpponentLandCount > myLandCount;
    }
}

