/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.v.VeronicaDissidentScribeWatcher;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.DiscardedCardsEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.JunkToken;
import mage.game.permanent.token.Token;

class VeronicaDissidentScribeTriggeredAbility
extends TriggeredAbilityImpl {
    VeronicaDissidentScribeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new JunkToken()));
        this.addWatcher(new VeronicaDissidentScribeWatcher());
        this.setTriggerPhrase("Whenever you discard one or more nonland cards for the first time each turn, ");
    }

    private VeronicaDissidentScribeTriggeredAbility(VeronicaDissidentScribeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DISCARDED_CARDS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        VeronicaDissidentScribeWatcher watcher = (VeronicaDissidentScribeWatcher)game.getState().getWatcher(VeronicaDissidentScribeWatcher.class);
        DiscardedCardsEvent discardedCardsEvent = (DiscardedCardsEvent)event;
        boolean nonlandCardsWereDiscarded = !discardedCardsEvent.getDiscardedCards().getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game).isEmpty();
        return watcher != null && watcher.numTimesDiscardedNonlandCardThisTurn(event.getPlayerId()) <= 1 && event.getPlayerId().equals(this.getControllerId()) && event.getAmount() != 0 && nonlandCardsWereDiscarded;
    }

    public VeronicaDissidentScribeTriggeredAbility copy() {
        return new VeronicaDissidentScribeTriggeredAbility(this);
    }
}

