/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.util.functions.CopyApplier;

class VesuvanDrifterEffect
extends OneShotEffect {
    private static final CopyApplier applier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID targetObjectId) {
            blueprint.getAbilities().add((Object)FlyingAbility.getInstance());
            return true;
        }
    };

    VesuvanDrifterEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library. If you reveal a creature card this way, {this} becomes a copy of that card until end of turn, except it has flying";
    }

    private VesuvanDrifterEffect(VesuvanDrifterEffect effect) {
        super((OneShotEffect)effect);
    }

    public VesuvanDrifterEffect copy() {
        return new VesuvanDrifterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (!card.isCreature(game) || source.getSourcePermanentIfItStillExists(game) == null) {
            return true;
        }
        game.copyPermanent(Duration.EndOfTurn, (Permanent)new PermanentCard(card, source.getControllerId(), game), source.getSourceId(), source, applier);
        return true;
    }
}

