/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.UnblockedPredicate;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class VeteranBodyguardEffect
extends PreventionEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("unblocked creatures");

    VeteranBodyguardEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "all combat damage that would be dealt to you by unblocked creatures is dealt to {this} instead";
    }

    private VeteranBodyguardEffect(VeteranBodyguardEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamagePlayerEvent damageEvent = (DamagePlayerEvent)event;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            permanent.damage(damageEvent.getAmount(), event.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable());
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent p;
        if (event.getPlayerId().equals(source.getControllerId()) && ((DamageEvent)event).isCombatDamage() && (p = game.getPermanent(source.getSourceId())) != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                if (!event.getSourceId().equals(permanent.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public VeteranBodyguardEffect copy() {
        return new VeteranBodyguardEffect(this);
    }

    static {
        filter.add((Predicate)UnblockedPredicate.instance);
    }
}

