/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.common.counter.ProliferateEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class VexingRadgullEffect
extends OneShotEffect {
    VexingRadgullEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player gets two rad counters if they don't have any rad counters. Otherwise, proliferate. <i>(Choose any number of permanents and/or players, then give each another counter of each kind already there.)</i>";
    }

    private VexingRadgullEffect(VexingRadgullEffect effect) {
        super((OneShotEffect)effect);
    }

    public VexingRadgullEffect copy() {
        return new VexingRadgullEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        if (player.getCountersCount(CounterType.RAD) == 0) {
            return new AddCountersTargetEffect(CounterType.RAD.createInstance(2)).setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
        }
        return new ProliferateEffect().apply(game, source);
    }
}

