/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class VeyranVoiceOfDualityEffect
extends ReplacementEffectImpl {
    VeyranVoiceOfDualityEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if you casting or copying an instant or sorcery spell causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time";
    }

    private VeyranVoiceOfDualityEffect(VeyranVoiceOfDualityEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public VeyranVoiceOfDualityEffect copy() {
        return new VeyranVoiceOfDualityEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        NumberOfTriggersEvent numberOfTriggersEvent = (NumberOfTriggersEvent)event;
        GameEvent sourceEvent = numberOfTriggersEvent.getSourceEvent();
        if (sourceEvent == null) {
            return false;
        }
        if (sourceEvent.getType() == GameEvent.EventType.SPELL_CAST || sourceEvent.getType() == GameEvent.EventType.COPIED_STACKOBJECT) {
            Spell spell = game.getSpell(sourceEvent.getTargetId());
            Permanent permanent = game.getPermanent(((NumberOfTriggersEvent)event).getSourceId());
            return spell != null && permanent != null && spell.isInstantOrSorcery(game) && spell.isControlledBy(source.getControllerId()) && permanent.isControlledBy(source.getControllerId());
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }
}

