/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Library;
import mage.players.Player;

class VigeanIntuitionEffect
extends OneShotEffect {
    private static final Set<String> choice = new LinkedHashSet<String>();

    public VigeanIntuitionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a card type, then reveal the top four cards of your library. Put all cards of the chosen type revealed this way into your hand and the rest into your graveyard";
    }

    private VigeanIntuitionEffect(VigeanIntuitionEffect effect) {
        super((OneShotEffect)effect);
    }

    public VigeanIntuitionEffect copy() {
        return new VigeanIntuitionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        Player player = game.getPlayer(source.getControllerId());
        if (sourceObject == null || player == null) {
            return false;
        }
        Library library = player.getLibrary();
        if (library == null) {
            return false;
        }
        ChoiceImpl choiceImpl = new ChoiceImpl(true);
        choiceImpl.setChoices(choice);
        if (player.choose(Outcome.Neutral, (Choice)choiceImpl, game)) {
            String chosenType = choiceImpl.getChoice();
            if (chosenType == null || chosenType.isEmpty()) {
                return false;
            }
            CardType type = null;
            if (chosenType.equals(CardType.ARTIFACT.toString())) {
                type = CardType.ARTIFACT;
            } else if (chosenType.equals(CardType.LAND.toString())) {
                type = CardType.LAND;
            } else if (chosenType.equals(CardType.CREATURE.toString())) {
                type = CardType.CREATURE;
            } else if (chosenType.equals(CardType.ENCHANTMENT.toString())) {
                type = CardType.ENCHANTMENT;
            } else if (chosenType.equals(CardType.INSTANT.toString())) {
                type = CardType.INSTANT;
            } else if (chosenType.equals(CardType.SORCERY.toString())) {
                type = CardType.SORCERY;
            } else if (chosenType.equals(CardType.PLANESWALKER.toString())) {
                type = CardType.PLANESWALKER;
            } else if (chosenType.equals(CardType.KINDRED.toString())) {
                type = CardType.KINDRED;
            }
            if (type != null) {
                Set top = library.getTopCards(game, 4);
                player.revealCards(source, (Cards)new CardsImpl(top), game);
                CardsImpl putInHand = new CardsImpl();
                CardsImpl putInGraveyard = new CardsImpl();
                for (Card card : top) {
                    if (card != null && card.getCardType(game).contains(type)) {
                        putInHand.add(card);
                        continue;
                    }
                    putInGraveyard.add(card);
                }
                player.moveCards((Cards)putInHand, Zone.HAND, source, game);
                player.moveCards((Cards)putInGraveyard, Zone.GRAVEYARD, source, game);
                return true;
            }
        }
        return false;
    }

    static {
        choice.add(CardType.ARTIFACT.toString());
        choice.add(CardType.CREATURE.toString());
        choice.add(CardType.ENCHANTMENT.toString());
        choice.add(CardType.INSTANT.toString());
        choice.add(CardType.LAND.toString());
        choice.add(CardType.PLANESWALKER.toString());
        choice.add(CardType.SORCERY.toString());
        choice.add(CardType.KINDRED.toString());
    }
}

