/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.v.VileRedeemerNonTokenCreaturesDiedWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.EldraziScionToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class VileRedeemerEffect
extends OneShotEffect {
    VileRedeemerEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a 1/1 colorless Eldrazi Scion creature token for each nontoken creature that died under your control this turn. Those tokens have \"Sacrifice this creature: Add {C}.\"";
    }

    private VileRedeemerEffect(VileRedeemerEffect effect) {
        super((OneShotEffect)effect);
    }

    public VileRedeemerEffect copy() {
        return new VileRedeemerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int amount;
            VileRedeemerNonTokenCreaturesDiedWatcher watcher = (VileRedeemerNonTokenCreaturesDiedWatcher)game.getState().getWatcher(VileRedeemerNonTokenCreaturesDiedWatcher.class);
            if (watcher != null && (amount = watcher.getAmountOfNontokenCreatureDiedThisTurn(controller.getId())) > 0) {
                return new CreateTokenEffect((Token)new EldraziScionToken(), amount).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

