/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.watchers.Watcher;

class VileRedeemerNonTokenCreaturesDiedWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfCreaturesThatDied = new HashMap<UUID, Integer>();

    public VileRedeemerNonTokenCreaturesDiedWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).isDiesEvent() && zEvent.getTarget() != null && zEvent.getTarget().isCreature(game) && !(zEvent.getTarget() instanceof PermanentToken)) {
            int count = this.getAmountOfNontokenCreatureDiedThisTurn(zEvent.getTargetId());
            this.amountOfCreaturesThatDied.put(zEvent.getTarget().getControllerId(), ++count);
        }
    }

    public void reset() {
        super.reset();
        this.amountOfCreaturesThatDied.clear();
    }

    public int getAmountOfNontokenCreatureDiedThisTurn(UUID playerId) {
        return this.amountOfCreaturesThatDied.getOrDefault(playerId, 0);
    }
}

