/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class VillainousWrathEffect
extends OneShotEffect {
    VillainousWrathEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent loses life equal to the number of creatures they control";
    }

    private VillainousWrathEffect(VillainousWrathEffect effect) {
        super((OneShotEffect)effect);
    }

    public VillainousWrathEffect copy() {
        return new VillainousWrathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int amount = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game);
        return amount > 0 && player.loseLife(amount, game, source, false) > 0;
    }
}

