/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.choices.ChooseFriendsAndFoes;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetSacrifice;

class VirtussManeuverEffect
extends OneShotEffect {
    VirtussManeuverEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each player, choose friend or foe. Each friend returns a creature card from their graveyard to their hand. Each foe sacrifices a creature they control";
    }

    private VirtussManeuverEffect(VirtussManeuverEffect effect) {
        super((OneShotEffect)effect);
    }

    public VirtussManeuverEffect copy() {
        return new VirtussManeuverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInGraveyard target;
        Player controller = game.getPlayer(source.getControllerId());
        ChooseFriendsAndFoes choice = new ChooseFriendsAndFoes();
        if (controller != null && !choice.chooseFriendOrFoe(controller, source, game)) {
            return false;
        }
        HashMap<UUID, Card> getBackMap = new HashMap<UUID, Card>();
        for (Player player : choice.getFriends()) {
            if (player == null) continue;
            FilterCreatureCard filter = new FilterCreatureCard("creature card in your graveyard");
            filter.add((Predicate)new OwnerIdPredicate(player.getId()));
            target = new TargetCardInGraveyard((FilterCard)filter);
            getBackMap.put(player.getId(), null);
            if (!player.choose(Outcome.ReturnToHand, (Target)target, source, game)) continue;
            getBackMap.put(player.getId(), game.getCard(target.getFirstTarget()));
        }
        for (Player player : choice.getFriends()) {
            Card card;
            if (player == null || (card = (Card)getBackMap.getOrDefault(player.getId(), null)) == null) continue;
            player.moveCards(card, Zone.HAND, source, game);
        }
        ArrayList perms = new ArrayList();
        for (Player player : choice.getFoes()) {
            if (player == null) continue;
            target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_CONTROLLED_A_CREATURE);
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            perms.addAll(target.getTargets());
        }
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

