/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.choices.Choice;
import mage.choices.ChoiceBasicLandType;
import mage.choices.ChoiceLandType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VisionCharmEffect
extends ContinuousEffectImpl {
    private String targetLandType;
    private SubType targetBasicLandType;

    VisionCharmEffect() {
        super(Duration.EndOfTurn, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
        this.staticText = "Choose a land type and a basic land type. Each land of the first chosen type becomes the second chosen type until end of turn.";
    }

    private VisionCharmEffect(VisionCharmEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.targetLandType = effect.targetLandType;
        this.targetBasicLandType = effect.targetBasicLandType;
    }

    public VisionCharmEffect copy() {
        return new VisionCharmEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ChoiceLandType choice = new ChoiceLandType();
            if (!controller.choose(this.outcome, (Choice)choice, game)) {
                this.discard();
                return;
            }
            this.targetLandType = choice.getChoice();
            choice = new ChoiceBasicLandType();
            if (!controller.choose(this.outcome, (Choice)choice, game)) {
                this.discard();
                return;
            }
            this.targetBasicLandType = SubType.byDescription((String)choice.getChoice());
            if (this.targetLandType == null || this.targetBasicLandType == null) {
                this.discard();
                return;
            }
        } else {
            this.discard();
            return;
        }
        FilterLandPermanent filter = new FilterLandPermanent();
        filter.add((Predicate)SubType.byDescription((String)this.targetLandType).getPredicate());
        if (this.getAffectedObjectsSet()) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                this.affectedObjectList.add(new MageObjectReference((MageObject)permanent, game));
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent land = ((MageObjectReference)it.next()).getPermanent(game);
            if (land == null) {
                it.remove();
                continue;
            }
            land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
            land.addSubType(game, new SubType[]{this.targetBasicLandType});
            land.removeAllAbilities(source.getSourceId(), game);
            switch (this.targetBasicLandType) {
                case FOREST: {
                    land.addAbility((Ability)new GreenManaAbility(), source.getSourceId(), game);
                    break;
                }
                case PLAINS: {
                    land.addAbility((Ability)new WhiteManaAbility(), source.getSourceId(), game);
                    break;
                }
                case MOUNTAIN: {
                    land.addAbility((Ability)new RedManaAbility(), source.getSourceId(), game);
                    break;
                }
                case ISLAND: {
                    land.addAbility((Ability)new BlueManaAbility(), source.getSourceId(), game);
                    break;
                }
                case SWAMP: {
                    land.addAbility((Ability)new BlackManaAbility(), source.getSourceId(), game);
                }
            }
        }
        return true;
    }
}

