/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.v.VivienChampionOfTheWildsCastFromExileEffect;
import mage.cards.v.VivienChampionOfTheWildsLookEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class VivienChampionOfTheWildsEffect
extends OneShotEffect {
    VivienChampionOfTheWildsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top three cards of your library. Exile one face down and put the rest on the bottom of your library in any order. For as long as it remains exiled, you may look at that card and you may cast it if it's a creature card.";
    }

    private VivienChampionOfTheWildsEffect(VivienChampionOfTheWildsEffect effect) {
        super((OneShotEffect)effect);
    }

    public VivienChampionOfTheWildsEffect copy() {
        return new VivienChampionOfTheWildsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterCard filter;
        TargetCardInLibrary target;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cardsToLook = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        if (!player.choose(this.outcome, (Cards)cardsToLook, (TargetCard)(target = new TargetCardInLibrary(filter = new FilterCard("card to exile face down"))), source, game)) {
            return false;
        }
        Card cardToExile = game.getCard(target.getFirstTarget());
        if (!player.moveCardsToExile(cardToExile, source, game, false, CardUtil.getCardExileZoneId((Game)game, (Ability)source), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, (String)" (look and cast)"))) {
            return false;
        }
        cardToExile.setFaceDown(true, game);
        AsThoughEffectImpl effect = new VivienChampionOfTheWildsLookEffect(player.getId());
        effect.setTargetPointer((TargetPointer)new FixedTarget(cardToExile, game));
        game.addEffect((ContinuousEffect)effect, source);
        if (cardToExile.isCreature(game)) {
            effect = new VivienChampionOfTheWildsCastFromExileEffect(player.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(cardToExile, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        CardsImpl cardsToBottom = new CardsImpl((Collection)cardsToLook);
        cardsToBottom.remove(cardToExile);
        player.putCardsOnBottomOfLibrary((Cards)cardsToBottom, game, source, true);
        return true;
    }
}

