/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.BeastToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class VivienMonstersAdvocateTokenEffect
extends OneShotEffect {
    private static final Token token = new BeastToken();
    private static final Set<String> choices = new LinkedHashSet<String>(Arrays.asList("Vigilance", "Reach", "Trample"));

    VivienMonstersAdvocateTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create a 3/3 green Beast creature token. Put your choice of a vigilance counter, a reach counter, or a trample counter on it.";
    }

    private VivienMonstersAdvocateTokenEffect(VivienMonstersAdvocateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public VivienMonstersAdvocateTokenEffect copy() {
        return new VivienMonstersAdvocateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        token.putOntoBattlefield(1, game, source, source.getControllerId());
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose vigilance, reach, or trample counter");
            choice.setChoices(choices);
            player.choose(this.outcome, (Choice)choice, game);
            String chosen = choice.getChoice();
            if (chosen == null) continue;
            permanent.addCounters(CounterType.findByName((String)chosen.toLowerCase(Locale.ENGLISH)).createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }
}

