/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class VivienOnTheHuntMillEffect
extends OneShotEffect {
    VivienOnTheHuntMillEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill five cards, then put any number of creature cards milled this way into your hand";
    }

    private VivienOnTheHuntMillEffect(VivienOnTheHuntMillEffect effect) {
        super((OneShotEffect)effect);
    }

    public VivienOnTheHuntMillEffect copy() {
        return new VivienOnTheHuntMillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Cards cards = player.millCards(5, source, game);
        if (cards.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) < 1) {
            return true;
        }
        TargetCard target = new TargetCard(0, Integer.MAX_VALUE, Zone.ALL, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        player.choose(this.outcome, cards, target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
        return true;
    }
}

