/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileReturnBattlefieldNextEndStepTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.AttackedThisTurnWatcher;
import mage.watchers.common.BlockedThisTurnWatcher;

class VizierOfDefermentEffect
extends OneShotEffect {
    VizierOfDefermentEffect() {
        super(Outcome.Detriment);
        this.staticText = "you may exile target creature if it attacked or blocked this turn. Return that card to the battlefield under its owner's control at the beginning of the next end step";
    }

    private VizierOfDefermentEffect(VizierOfDefermentEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        AttackedThisTurnWatcher watcherAttacked = (AttackedThisTurnWatcher)game.getState().getWatcher(AttackedThisTurnWatcher.class);
        BlockedThisTurnWatcher watcherBlocked = (BlockedThisTurnWatcher)game.getState().getWatcher(BlockedThisTurnWatcher.class);
        boolean attackedOrBlocked = false;
        if (watcherAttacked != null && watcherAttacked.checkIfAttacked(permanent, game)) {
            attackedOrBlocked = true;
        }
        if (watcherBlocked != null && watcherBlocked.checkIfBlocked(permanent, game)) {
            attackedOrBlocked = true;
        }
        if (!attackedOrBlocked) {
            return false;
        }
        ExileReturnBattlefieldNextEndStepTargetEffect effect = new ExileReturnBattlefieldNextEndStepTargetEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
        return effect.apply(game, source);
    }

    public VizierOfDefermentEffect copy() {
        return new VizierOfDefermentEffect(this);
    }
}

