/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.cards.v.EmbalmedThisTurnWatcher;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.util.functions.CopyApplier;

class VizierOfManyFacesCopyApplier
extends CopyApplier {
    VizierOfManyFacesCopyApplier() {
    }

    public boolean apply(Game game, MageObject blueprint, Ability source, UUID copyToObjectId) {
        for (Permanent entering : game.getPermanentsEntering().values()) {
            if (!entering.getId().equals(copyToObjectId) || !(entering instanceof PermanentToken)) continue;
            UUID originalCardId = ((PermanentToken)entering).getToken().getCopySourceCard().getId();
            EmbalmedThisTurnWatcher watcher = (EmbalmedThisTurnWatcher)game.getState().getWatcher(EmbalmedThisTurnWatcher.class);
            if (watcher == null) continue;
            for (MageObjectReference mor : watcher.getEmbalmedThisTurnCards()) {
                if (!Objects.equals(mor.getSourceId(), originalCardId) || game.getState().getZoneChangeCounter(originalCardId) != mor.getZoneChangeCounter()) continue;
                blueprint.getManaCost().clear();
                if (!blueprint.getSubtype().contains((Object)SubType.ZOMBIE)) {
                    blueprint.getSubtype().add((Object)SubType.ZOMBIE);
                }
                blueprint.getColor().setColor(ObjectColor.WHITE);
            }
        }
        return true;
    }
}

