/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class VizkopaConfessorEffect
extends OneShotEffect {
    VizkopaConfessorEffect() {
        super(Outcome.Benefit);
        this.staticText = "pay any amount of life. Target opponent reveals that many cards from their hand. You choose one of them and exile it";
    }

    private VizkopaConfessorEffect(VizkopaConfessorEffect effect) {
        super((OneShotEffect)effect);
    }

    public VizkopaConfessorEffect copy() {
        return new VizkopaConfessorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int payLife;
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Card sourceCard = game.getCard(source.getSourceId());
        if (controller != null && targetPlayer != null && sourceCard != null && (payLife = controller.getAmount(0, controller.getLife(), "Pay how many life?", source, game)) > 0) {
            controller.loseLife(payLife, game, source, false);
            game.informPlayers(sourceCard.getName() + ": " + controller.getLogName() + " pays " + payLife + " life");
            CardsImpl cardsInHand = new CardsImpl();
            cardsInHand.addAll((Collection)targetPlayer.getHand());
            int count = Math.min(cardsInHand.size(), payLife);
            TargetCard target = new TargetCard(count, Zone.HAND, new FilterCard());
            CardsImpl revealedCards = new CardsImpl();
            if (targetPlayer.chooseTarget(Outcome.Discard, (Cards)cardsInHand, target, source, game)) {
                List targets = target.getTargets();
                for (UUID targetId : targets) {
                    Card card = game.getCard(targetId);
                    if (card == null) continue;
                    revealedCards.add(card);
                }
            }
            TargetCard targetInHand = new TargetCard(Zone.HAND, new FilterCard("card to exile"));
            if (!revealedCards.isEmpty()) {
                targetPlayer.revealCards(sourceCard.getName(), (Cards)revealedCards, game);
                controller.chooseTarget(Outcome.Exile, (Cards)revealedCards, targetInHand, source, game);
                Card card = revealedCards.get(targetInHand.getFirstTarget(), game);
                if (card != null) {
                    controller.moveCardToExileWithInfo(card, null, null, source, game, Zone.HAND, true);
                }
            }
            return true;
        }
        return false;
    }
}

