/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.v.VodalianWarMachineWatcher;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class VodalianWarMachineEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("Merfolk tapped this turn to pay for its abilities");

    VodalianWarMachineEffect() {
        super(Outcome.Detriment);
        this.staticText = "destroy all " + filter.getMessage();
    }

    private VodalianWarMachineEffect(VodalianWarMachineEffect effect) {
        super((OneShotEffect)effect);
    }

    public VodalianWarMachineEffect copy() {
        return new VodalianWarMachineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        VodalianWarMachineWatcher watcher;
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourcePermanent != null && (watcher = (VodalianWarMachineWatcher)game.getState().getWatcher(VodalianWarMachineWatcher.class)) != null && watcher.getTappedMerfolkIds(sourcePermanent, game) != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                if (!watcher.getTappedMerfolkIds(sourcePermanent, game).contains(new MageObjectReference((MageObject)permanent, game))) continue;
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.MERFOLK.getPredicate());
    }
}

