/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class VoharVodalianDesecratorEffect
extends OneShotEffect {
    VoharVodalianDesecratorEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw a card, then discard a card. If you discarded an instant or sorcery card this way, each opponent loses 1 life and you gain 1 life.";
    }

    private VoharVodalianDesecratorEffect(VoharVodalianDesecratorEffect effect) {
        super((OneShotEffect)effect);
    }

    public VoharVodalianDesecratorEffect copy() {
        return new VoharVodalianDesecratorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.drawCards(1, source, game);
        for (UUID cardId : controller.discard(1, false, false, source, game)) {
            Card card = game.getCard(cardId);
            if (card == null || !card.isInstantOrSorcery(game)) continue;
            for (UUID opponentId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(opponentId);
                if (opponent == null) continue;
                opponent.loseLife(1, game, source, false);
            }
            controller.gainLife(1, game, source);
            break;
        }
        return true;
    }
}

