/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class VoidMawCost
extends CostImpl {
    public VoidMawCost() {
        this.text = "Put a card exiled with {this} into its owner's graveyard";
    }

    private VoidMawCost(VoidMawCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            Card card;
            TargetCardInExile target = new TargetCardInExile(new FilterCard(), CardUtil.getCardExileZoneId((Game)game, (Ability)ability));
            target.withNotTarget(true);
            ExileZone cards = game.getExile().getExileZone(CardUtil.getCardExileZoneId((Game)game, (Ability)ability));
            if (cards != null && !cards.isEmpty() && controller.choose(Outcome.Benefit, (Cards)cards, (TargetCard)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null && controller.moveCardToGraveyardWithInfo(card, source, game, Zone.EXILED)) {
                this.paid = true;
            }
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player player = game.getPlayer(controllerId);
        return player != null;
    }

    public VoidMawCost copy() {
        return new VoidMawCost(this);
    }
}

