/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.ExchangeControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VolatileStormdrakeEffect
extends OneShotEffect {
    VolatileStormdrakeEffect() {
        super(Outcome.GainControl);
        this.staticText = "exchange control of {this} and target creature an opponent controls. If you do, you get {E}{E}{E}{E}, then sacrifice that creature unless you pay an amount of {E} equal to its mana value";
    }

    private VolatileStormdrakeEffect(VolatileStormdrakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public VolatileStormdrakeEffect copy() {
        return new VolatileStormdrakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (sourceObject == null) {
            return false;
        }
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetPermanent == null) {
            return false;
        }
        ExchangeControlTargetEffect effect = new ExchangeControlTargetEffect(Duration.EndOfGame, "", true);
        effect.setTargetPointer(this.getTargetPointer().copy());
        game.addEffect((ContinuousEffect)effect, source);
        game.processAction();
        controller.addCounters(CounterType.ENERGY.createInstance(4), controller.getId(), source, game);
        new DoIfCostPaid(null, (Effect)new SacrificeTargetEffect("", controller.getId()), (Cost)new PayEnergyCost(targetPermanent.getManaValue()), true).apply(game, source);
        return true;
    }
}

