/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VolcanicVisionReturnToHandTargetEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public VolcanicVisionReturnToHandTargetEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target instant or sorcery card from your graveyard to your hand. {this} deals damage equal to that card's mana value to each creature your opponents control";
    }

    private VolcanicVisionReturnToHandTargetEffect(VolcanicVisionReturnToHandTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public VolcanicVisionReturnToHandTargetEffect copy() {
        return new VolcanicVisionReturnToHandTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            switch (game.getState().getZone(targetId)) {
                case GRAVEYARD: {
                    Card card = game.getCard(targetId);
                    if (card == null) break;
                    controller.moveCards(card, Zone.HAND, source, game);
                    int damage = card.getManaValue();
                    if (damage <= 0) break;
                    for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                        creature.damage(damage, source.getSourceId(), source, game, false, true);
                    }
                    break;
                }
            }
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
    }
}

