/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.VolosJournalToken;
import mage.players.Player;

class VoloItinerantScholarEffect
extends OneShotEffect {
    VoloItinerantScholarEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card for each creature type noted for target permanent you control named Volo's Journal";
    }

    private VoloItinerantScholarEffect(VoloItinerantScholarEffect effect) {
        super((OneShotEffect)effect);
    }

    public VoloItinerantScholarEffect copy() {
        return new VoloItinerantScholarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        return player.drawCards(VolosJournalToken.getNotedTypes((Game)game, (Permanent)permanent).size(), source, game) > 0;
    }
}

