/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class VolrathsDungeonEffect
extends OneShotEffect {
    VolrathsDungeonEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target player puts a card from their hand on top of their library";
    }

    private VolrathsDungeonEffect(VolrathsDungeonEffect effect) {
        super((OneShotEffect)effect);
    }

    public VolrathsDungeonEffect copy() {
        return new VolrathsDungeonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetedPlayer = game.getPlayer(source.getFirstTarget());
        if (targetedPlayer != null) {
            TargetCardInHand target = new TargetCardInHand();
            if (targetedPlayer.choose(Outcome.Detriment, targetedPlayer.getHand(), (TargetCard)target, source, game)) {
                Card card = game.getCard(target.getFirstTarget());
                return card != null && targetedPlayer.putCardOnTopXOfLibrary(card, game, source, 0, false);
            }
        }
        return false;
    }
}

